#include <irrlicht.h>
#include <string>

#ifdef _IRR_WINDOWS_
#pragma comment(lib, "Irrlicht.lib")
#endif

class CMainClass : public irr::IEventReceiver 
{
private:
	irr::video::IVideoDriver  *m_pDrv;
	irr::gui::IGUIEnvironment *m_pGui;

	irr::gui::IGUITreeView *m_pTree;
	irr::gui::IGUICheckBox *m_pAllow;

	void addTreeNodes(irr::gui::IGUITreeViewNode *a_pParent, int a_iLevel, int a_iParent, int &a_iCount) {
		for (int i = 0; i < 3; i++) {
			irr::core::stringw l_sText(L"TreeNode ");
			l_sText += irr::core::stringw(++a_iCount);
			irr::gui::IGUITreeViewNode *l_pNode = a_pParent->addChildBack(l_sText.c_str(), 0, -1, -1);
			if (a_iLevel < 3) 
				addTreeNodes(l_pNode, a_iLevel + 1, i, a_iCount);
		}
	}

public:
	irr::IrrlichtDevice *m_pDevice;

	CMainClass() : m_pDevice(nullptr), m_pDrv(nullptr), m_pGui(nullptr), m_pTree(nullptr) {
		m_pDevice = irr::createDevice(irr::video::EDT_OPENGL, irr::core::dimension2du(1680, 1024));

		if (m_pDevice) {
			m_pDevice->setWindowCaption(L"TreeView Test");
			m_pDevice->setEventReceiver(this);

			m_pDrv = m_pDevice->getVideoDriver();
			m_pGui = m_pDevice->getGUIEnvironment();

			irr::gui::IGUIFont *l_pFont = m_pGui->getFont("font.png");
			if (l_pFont != nullptr)
				m_pGui->getSkin()->setFont(l_pFont);
			else
				printf("Oops.");

			irr::u32 l_iHeight = m_pGui->getSkin()->getFont()->getDimension(L"X").Height;

			m_pTree  = m_pGui->addTreeView(irr::core::recti(100, 100, 1000, 900));
			m_pAllow = m_pGui->addCheckBox(false, irr::core::recti(100, 95 - l_iHeight, 100 + l_iHeight, 95));

			m_pGui->addStaticText(L" Allow Drag / Drop", irr::core::recti(100 + l_iHeight, 95 - l_iHeight, 1000, 95))->setTextAlignment(irr::gui::EGUIA_UPPERLEFT, irr::gui::EGUIA_CENTER);

			int i = 0;
			m_pTree->getRoot()->addChildBack(L"Cannot Drag");
			addTreeNodes(m_pTree->getRoot(), 0, -1, i);
			m_pTree->getRoot()->addChildBack(L"Cannot Drop");
		}
	}


	~CMainClass()
	{
		m_pDevice->drop();
	}

	bool run() {
		if (m_pDevice->run()) {
			m_pDrv->beginScene(true, true, irr::video::SColor(255, 224, 224, 224));
			m_pGui->drawAll();
			m_pDrv->endScene();

			return true;
		}
		else return false;
	}

	virtual bool OnEvent(const irr::SEvent &a_cEvent) override {
		bool l_bRet = false;

		if (a_cEvent.EventType == irr::EET_MOUSE_INPUT_EVENT) {
			if (a_cEvent.MouseInput.Event == irr::EMIE_MOUSE_MOVED) {
				// irr::gui::IGUITreeViewNode *l_pNode = m_pTree->getNodeAt(irr::core::position2di(a_cEvent.MouseInput.X, a_cEvent.MouseInput.Y));
				// if (l_pNode != nullptr)
				//   printf("==> %ls\n", l_pNode->getText());
				// else
				//   printf("==> null\n");
			}

			irr::gui::EGET_TREEVIEW_NODE_COLLAPS;
		}
		else if (a_cEvent.EventType == irr::EET_GUI_EVENT) {
			if (a_cEvent.GUIEvent.EventType == irr::gui::EGET_TREEVIEW_NODE_DRAG) {
				if (m_pTree->getLastEventNode() != nullptr) {
					printf("Drag Node: %ls\n", m_pTree->getLastEventNode()->getText());
					if (std::wstring(L"Cannot Drag") == m_pTree->getLastEventNode()->getText())
						m_pTree->cancelNodeDrag();
				}
				else printf("Nothing dragged\n");
			}
			else if (a_cEvent.GUIEvent.EventType == irr::gui::EGET_TREEVIEW_NODE_DROP) {
				if (m_pTree->getLastEventNode() != nullptr)
					printf("Drop Node: %ls\n", m_pTree->getLastEventNode()->getText());
				else
					printf("Nothing dropeed\n");
			}
			else if (a_cEvent.GUIEvent.EventType == irr::gui::EGET_TREEVIEW_DRAG_CANCELED) {
				printf("Dragging canceled\n");
			}
			else if (a_cEvent.GUIEvent.EventType == irr::gui::EGET_TREEVIEW_NODE_WILL_DROP) {
				if (a_cEvent.GUIEvent.Caller == m_pTree) {
					irr::gui::IGUITreeViewNode *l_pNode = m_pTree->getLastEventNode();
					if (l_pNode != nullptr) {
						if (std::wstring(L"Cannot Drop") == l_pNode->getText())
							m_pTree->cancelNodeDrag();
					}
				}
			}
			else if (a_cEvent.GUIEvent.EventType == irr::gui::EGET_CHECKBOX_CHANGED) {
				if (a_cEvent.GUIEvent.Caller == m_pAllow)
					m_pTree->setDraggingAllowed(m_pAllow->isChecked());
			}
		}

		return l_bRet;
	}
};

int main(void) 
{
	CMainClass l_cMain;

	while (l_cMain.run()) 
	{
		l_cMain.m_pDevice->yield();
	}
}
