#ifndef __PROFILER_H_INCLUDED__
#define __PROFILER_H_INCLUDED__

// enable/disable profiler
#define IRR_PROFILE	1

#define PROFILER_GUI_ID 987654

#include <irrlicht.h>
#include <map>
#include <string>
#include <iostream>

namespace irr
{

struct ProfileData
{
    ProfileData();
    void Reset();

    u32 mGroupId;
    std::string mName;

    u32 mCountCalls;
    u32 mHighestTime;
    u32 mLowestTime;
    u32 mTimeSum;

    u32 mLastTimeStarted;
};

class Profiler
{
public:
    Profiler();
    virtual ~Profiler();

    void Init(irr::ITimer * irrlichtTimer_, irr::gui::IGUIEnvironment * env_)         
	{ 
		mIrrTimer = irrlichtTimer_; 
		mGuiEnv = env_;
	}

    // set the rectangle used for the display listbox
    void SetDisplayRect(const core::rect<s32> &rect_)   { mDisplayRect = rect_; }

    void Add(u32 id_, u32 groupId_, const std::string &name_);
    void AddGroup(u32 groupId_, const std::string &name_);
    void Start(u32 id_);
    void Stop(u32 id_);

    void Reset(u32 id_);
    void ResetGroup(u32 groupId_);
    void ResetAll();
    void Show(irr::gui::IGUIEnvironment* env_);        // print current display group on screen
    void Hide(irr::gui::IGUIEnvironment* env_);
	void Print(std::ostream &stream_, bool suppressUncalled_=true);       // write current display group to wcout
    void PrintAll(std::ostream &stream_, bool suppressUncalled_=true);    // write all groups to wcout

    void SetDisplayGroup(u32 groupId_);
    void NextDisplayGroup();
    void PreviousDisplayGroup();
    void FirstDisplayGroup();

protected:
    void PrintGroup(std::ostream &stream_, u32 groupId_, bool suppressUncalled_);
    virtual std::string MakeDataString(const ProfileData & data_);
    virtual std::string MakeTitleString();

private:
    irr::ITimer * mIrrTimer;
	irr::gui::IGUIEnvironment * mGuiEnv;

    core::rect<s32> mDisplayRect;
    u32 mCurrentGroupId;
    typedef std::map<u32, ProfileData> ProfileDataMap;
    ProfileDataMap   mProfileDatas;
    ProfileDataMap   mProfileGroups;
};

extern Profiler gPROFILER;

#if IRR_PROFILE
	#define PROFILE_ADD(id_, groupId_, name_)   irr::gPROFILER.Add(id_, groupId_, name_)
    #define PROFILE_ADD_GROUP(groupId_, name_)  irr::gPROFILER.AddGroup(groupId_, name_)
    #define PROFILE_START(id_)                  irr::gPROFILER.Start(id_)
    #define PROFILE_STOP(id_)                   irr::gPROFILER.Stop(id_)
#else
    #define PROFILE_ADD(id_, groupId_, name_)
    #define PROFILE_ADD_GROUP(groupId_, name_)
    #define PROFILE_START(id_)
    #define PROFILE_STOP(id_)
#endif // IRR_PROFILE

} // namespace irr

#endif // __PROFILER_H_INCLUDED__
